function betagal = partition_func_1(X,N)

AHL = X(1:N);
CI = X(N+1:2*N);

%combined parameters
r_TI = 0.01;
beta = 1;
delta_m = log(2) / 5 / 60;
delta_p = log(2) / 30 / 60;

%This is the maximum protein concentration at steady-state, assuming that the probability of RNA Polymerase binding is 1.0
lambda_3 = r_TI * beta / delta_m / delta_p; 

%Free Energy Parameters for protein-DNA interactions at promoter (specific - non-specific binding)
%Shea-Ackers Formalism (Shea & Ackers, JMB, 1985) that also includes the
%effects of non-specific protein-DNA binding (also, see Bintu et. al., "Transcriptional
%regulation by the numbers: models"). 
dG_ns = -7.5;
dG_lux = -11.0 - dG_ns;
dG_CI_1 = -11.7 - dG_ns;
dG_CI_2 = -10.1 - dG_ns;
dG_CI_CI = 1.9000;
dG_lux_RNAP = -5;
dG_CI_RNAP = 20;
dG_RNAP = 0;

%Number of non-specific binding sites in the E. coli genome
N_ns = 1e6 / 1e-15 / 6.022e23 * 1000;
RT = 1.987 * 298 / 1000; %gas constant in kcal/mol/Kelvin multiplied by 298 deg Kelvin

%From data describing AHL binding to LuxR
m = 0.718; %Fitted from Urbanowski, Lostroh, and Greenberg (2004) [DNA:LuxR:AHL] vs. [AHL] at constant LuxR
Ka = 0.0001; %uM^-1 (Fitted from above, using Ka = 2 * 10^b / [LuxR]_constant
LuxR_tot = 0.16605; %100 molecules of LuxR converted to uM (assuming intracellular volume of 1e-15 L)
LuxR_AHL = LuxR_tot .* AHL.^m .* Ka ./ 2 ./ (1 + AHL.^m .* Ka ./ 2);

LuxR_AHL = LuxR_AHL ./ N_ns; %Effective concentration of AHL (MicroMolar)
CI = CI ./ N_ns / 2; %Effective concentration of CI dimers (MicroMolar)

RNAP = 0.03; %Effective concentration of RNAP. (MicroMolar)

%Gibbs free energies of all possible regulatory states in which the promoter may exist
dG(1) = 0; %reference state
dG(2) = dG_CI_1; %CI dimer bound to O1
dG(3) = dG_CI_2; %CI dimer bound to O2
dG(4) = dG_CI_1 + dG_CI_2 + dG_CI_CI; %CI dimers bound to O1 and O2
dG(5) = dG_lux; %luxR bound
dG(6) = dG_lux + dG_CI_1; %luxR and CI bound to O1
dG(7) = dG_lux + dG_CI_2; %luxR and CI bound to O2
dG(8) = dG_lux + dG_CI_1 + dG_CI_2 + dG_CI_CI; %luxR and CI bound to O1 and O2
dG(9) = dG_RNAP; %RNAP bound
dG(10) = dG_CI_1 + dG_RNAP + dG_CI_RNAP; %RNAP bound and CI bound to O1
dG(11) = dG_CI_2 + dG_RNAP + dG_CI_RNAP; %RNAP bound and CI bound to O2
dG(12) = dG_CI_1 + dG_CI_2 + dG_CI_CI + dG_RNAP + 2*dG_CI_RNAP; %RNAP bound and CI dimers bound to O1 and O2
dG(13) = dG_lux + dG_RNAP + dG_lux_RNAP; %RNAP and LuxR bound
dG(14) = dG_lux + dG_RNAP + dG_lux_RNAP + dG_CI_1 + dG_CI_RNAP; %RNAP, LuxR, and CI bound
dG(15) = dG_lux + dG_RNAP + dG_lux_RNAP + dG_CI_2 + dG_CI_RNAP; %RNAP, LuxR, and CI bound
dG(16) = dG_lux + dG_RNAP + dG_lux_RNAP + dG_CI_1 + dG_CI_2 + dG_CI_CI + 2*dG_CI_RNAP; %RNAP, LuxR, and CI bound

%Number (Density) of microstates per state
h = zeros(N,length(dG));
h(:,1) = 1;
h(:,2) = CI;
h(:,3) = CI;
h(:,4) = CI.*CI;
h(:,5) = LuxR_AHL;
h(:,6) = LuxR_AHL.*CI;
h(:,7) = LuxR_AHL.*CI;
h(:,8) = LuxR_AHL.*CI.*CI;
h(:,9) = RNAP;
h(:,10) = RNAP.*CI;
h(:,11) = RNAP.*CI;
h(:,12) = RNAP.*CI.*CI;
h(:,13) = RNAP.*LuxR_AHL;
h(:,14) = RNAP.*LuxR_AHL.*CI;
h(:,15) = RNAP.*LuxR_AHL.*CI;
h(:,16) = RNAP.*LuxR_AHL.*CI.*CI;

%Probability of the promoter being in one of its regulatory states
for i=1:length(dG)
    P(:,i) = h(:,i).*exp(-dG(i) / RT);
end

Q = sum(P,2);

%The probability that RNA Polymerase is in an initiation-competent state
Pinit = sum(P(:,9:16),2) ./ Q;

betagal = lambda_3 * Pinit; %steady amount of molecules of beta-gal per cell

